---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：14-Node Attributes Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティ権限名**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/rest/action/cat/RestNodeAttrsAction.java` 行68-70（ルート定義）
- E-02: `server/src/main/java/org/opensearch/rest/action/cat/RestNodeAttrsAction.java` 行83-106（doCatRequest処理）
- E-03: `server/src/main/java/org/opensearch/rest/action/cat/RestNodeAttrsAction.java` 行84-85（ClusterStateRequest nodes=true）
- E-04: `server/src/main/java/org/opensearch/rest/action/cat/RestNodeAttrsAction.java` 行95-97（NodesInfoRequest PROCESS）
- E-05: `server/src/main/java/org/opensearch/rest/action/cat/RestNodeAttrsAction.java` 行109-122（テーブルヘッダー定義）
- E-06: `server/src/main/java/org/opensearch/rest/action/cat/RestNodeAttrsAction.java` 行113（id default:false）
- E-07: `server/src/main/java/org/opensearch/rest/action/cat/RestNodeAttrsAction.java` 行114（pid default:false）
- E-08: `server/src/main/java/org/opensearch/rest/action/cat/RestNodeAttrsAction.java` 行117（port default:false）
- E-09: `server/src/main/java/org/opensearch/rest/action/cat/RestNodeAttrsAction.java` 行124-146（buildTable処理）
- E-10: `server/src/main/java/org/opensearch/rest/action/cat/RestNodeAttrsAction.java` 行125（full_idパラメータ）
- E-11: `server/src/main/java/org/opensearch/rest/action/cat/RestNodeAttrsAction.java` 行135（Strings.substring 0,4）
- E-12: `server/src/main/java/org/opensearch/rest/action/cat/RestNodeAttrsAction.java` 行136（info==null時null出力）
- E-13: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行15（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは /_cat/nodeattrs | E-01 | ○ |
| C-02 | 2段階非同期処理（ClusterState -> NodesInfo） | E-02 | ○ |
| C-03 | ClusterStateRequest で nodes=true | E-03 | ○ |
| C-04 | NodesInfoRequest で PROCESS メトリック指定 | E-04 | ○ |
| C-05 | テーブルカラムは8つ（node, id, pid, host, ip, port, attr, value） | E-05 | ○ |
| C-06 | id はデフォルト非表示 | E-06 | ○ |
| C-07 | pid はデフォルト非表示 | E-07 | ○ |
| C-08 | port はデフォルト非表示 | E-08 | ○ |
| C-09 | full_id=falseの場合ノードIDは4文字に短縮 | E-10, E-11 | ○ |
| C-10 | info==null時はPIDがnull出力 | E-12 | ○ |
| C-11 | DiscoveryNode×属性Mapのネストループ | E-09 | ○ |
| C-12 | attr のaliasは attr.name | E-05 | ○ |
| C-13 | value のaliasは attr.value | E-05 | ○ |
| C-14 | node のaliasは name | E-05 | ○ |
| C-15 | デフォルト表示カラムは node, attr, value | E-05 | ○ |
| C-16 | アクション名は cat_node_attrs_action | E-01 | ○ |
| C-17 | ソースファイルは全147行 | E-09 | ○ |
| C-18 | 帳票名は「Node Attributes Report」 | E-13 | ○ |
| C-19 | ProcessInfo.getId()でPID取得 | E-12 | ○ |
| C-20 | cluster:monitor/state と cluster:monitor/nodes/info 権限が必要 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティ権限名はSecurity pluginに依存
  - 候補：Security plugin documentation / Permission mapping

## 5) リスクフラグ（レビュー観点）
- 0: エンドポイント・カラム定義・処理フロー（ソースコード確認済み）
- 1: セキュリティ権限名（推定値）

## 6) レビュアーチェックリスト（最小）
- [ ] テーブルカラムのデフォルト表示/非表示が正確か確認
- [ ] full_idパラメータの短縮ロジック確認
- [ ] セキュリティ権限名の確認
